package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.common.model.BaseBasicDataVO;
import lombok.Data;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.*;

@Entity
@Table(name = "t_sys_user")
@Data
public class User extends BaseBasicDataVO<String> {
    @Id
    @Column(name = "id")
    private String id;

    @Column(name = "account")
    private String account;

    @Column(name = "email")
    private String email;

    @Column(name = "mobile")
    private String mobile;

    @Column(name = "is_enable")
    private Boolean isEnable;

    @Column(name = "password")
    private String password;

    @Column(name = "salt")
    private String salt;

    @Column(name = "is_change")
    private Boolean isChange;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "organization_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private Organization organization;

    private String supplierCode;

    private Integer tenantId;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
