package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.common.model.BaseTreeVO;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.*;

@Entity
@Table(name = "t_sys_organization")
public class Organization extends BaseTreeVO<Organization,String> {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Id
    @Column(name = "id")
    //jpa (hibernate实现)的UUID生成主键策略
    @GenericGenerator(name = "jpa-uuid", strategy = "org.hibernate.id.UUIDGenerator")
    @GeneratedValue(generator = "jpa-uuid") //使用jpa-uuid的生成策略
    private String id;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private Organization parent;

    /**
     * 服务商code
     */
    private String supplierCode;

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    @Override
    public Organization getParent() {
        return parent;
    }

    @Override
    public void setParent(Organization parent) {
        this.parent = parent;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

}
