package cn.quantgroup.big.stms.sys.dto;

import cn.quantgroup.big.stms.common.enums.BasicDataStatus;
import cn.quantgroup.big.stms.sys.model.Organization;
import lombok.Data;

import javax.validation.constraints.Size;
import java.util.List;

@Data
public class UserV2Dto {

  private String id;
  @Size( max = 32, message = "登录账号必须小于{max}")
  private String account;
  @Size(max = 64, message = "用户名称必须小于{max}")
  private String name;
  @Size(max = 128, message = "用户描述不能超过{max}")
  private String description;
  @Size(max = 15, message = "手机号不能超过{max}")
  private String mobile;
  @Size(max = 32, message = "用户编码必须小于{max}")
  private String code;
  @Size(max = 64, message = "电子邮箱必须小于{max}")
  private String email;
  private Organization organization;
  private List<String> roleId;

  private String orgId;

  private String supplierCode;

  private BasicDataStatus status;


}
