package cn.quantgroup.big.stms.sys.dto;

import lombok.Data;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Data
public class RoleSelectedDto {
  /**
   * 角色ID
   **/
  private String id;

  /**
   * 应用
   */
  @NotNull(message = "所属应用不为空")
  private AppTempDto app;

  /**
   * 角色编码
   **/
  @NotNull(message = "角色编码不为空")
  @Size(min = 1, max = 32, message = "角色编码必须在{min}-{max}之间")
  private String code;

  /**
   * 角色名称
   */
  @NotNull(message = "角色名称不为空")
  @Size(min = 1, max = 64, message = "角色名称必须在{min}-{max}之间")
  private String name;

  /**
   * 排序号
   **/
  @DecimalMax(value = "60000", message = "排序号不能超过{value}")
  @DecimalMin(value = "0", message = "排序号不能小于{value}")
  private Integer sortNo = 1;

  /**
   * 描述
   */
  @Size(max = 128, message = "角色描述不能超过{max}")
  private String description;

  /**
   * 租户id
   */
  @NotNull(message = "租户id不为空")
  private Integer tenantId;
}

