package cn.quantgroup.big.stms.sys.controller.v2;

import cn.quantgroup.big.stms.common.result.Result;
import cn.quantgroup.big.stms.sys.dao.RoleResourceDao;
import cn.quantgroup.big.stms.sys.dto.ResourceRoleDto;
import cn.quantgroup.big.stms.sys.service.UserService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.stream.Collectors;

@RestController
@RequestMapping(value = "/v2/resource", produces = {"application/json"})
public class ResourceV2Controller {

  @Autowired
  private UserService userService;

  @Autowired
  private RoleResourceDao roleResourceDao;
  /**
   * 获取当前用户，所在应用的所有资源
   *
   * @param appCode 应用编码
   * @return
   */
  @PostMapping("/{appCode}")
  public Result getResources(@PathVariable String appCode,
      @RequestParam(value = "tenantId", required = false) Integer tenantId) {
    return Result.success(userService.getResources(appCode, tenantId));
  }

  /**
   * 获取当前用户所在应用的所有资源以及选中的资源
   *
   * @param appCode 应用编码
   * @return
   */
  @PostMapping("/{appCode}/{roleId}")
  public Result getResources(@PathVariable String appCode,@PathVariable(required = false) String roleId,
      @RequestParam(value = "tenantId", required = false) Integer tenantId) {
    ResourceRoleDto resourceRoleDto  = new ResourceRoleDto();
    resourceRoleDto.setResource(userService.getResources(appCode, tenantId));
    if(StringUtils.isNotEmpty(roleId)){
      resourceRoleDto.setSelected(roleResourceDao.findByRoleId(roleId).stream().map(i->i.getResource().getId()).collect(
          Collectors.toList()));
    }
    return Result.success(resourceRoleDto);
  }
}
