package cn.quantgroup.big.stms.common.service;

import java.util.Set;

/**
 * 权限校验
 * @author yutong
 * @data 2020年1月19日
 */
public interface PermissionService {

	String ROLE_KEY = "role:user:";

	/**
	 * 检查登录用户的请求request与权限
	 * @param paths
	 * @return
	 */
	boolean checkIgnore(String... paths);
	
	/**
	 * 检查登录用户是否有指定权限 （TODO 未确认需求）
	 * @param ids
	 * @return
	 */
	boolean checkUsers(String... ids);

	/**
	 * 检查用户权限路径
	 * @param tenantId 租户id
	 * @param paths
	 * @return
	 */
	boolean checkUri(Integer tenantId,String... paths);



	
	/**
	 * 获取用户权限(正则转换)
	 * @param userid, null为刷新当前用户权限
	 * @return
	 */
	Set<String> getRegPermission(Integer tenantId ,String userid);

	/**
	 * 刷新用户权限
	 * @param userid, null为刷新当前用户权限
	 * @return
	 */
	String refreshPermission(String userid,Integer tenantId);

	/**
	 * 清理用户权限
	 * @param userIds
	 * @return
	 */
	boolean clearPermission(String... userIds);
}
