package cn.quantgroup.big.stms.common.result;

/**
 * API 调用返回的结果对象
 * 
 * @author rong yang
 *
 */
@SuppressWarnings("serial")
public class Result implements java.io.Serializable {

	private Integer code;

	/** 消息 **/
	private String msg;

	/** 详细消息 **/
	private String detail;

	/** 数据 **/
	private Object data;

	public String getMsg() {
		return msg;
	}

	public Object getData() {
		return data;
	}

	/**
	 * @return the code
	 */
	public Integer getCode() {
		return code;
	}

	public String getDetail() {
		return detail;
	}

	private void setDetail(String detail) {
		this.detail = detail;
	}

	/**
	 * @param resultCode
	 */
	protected void setResultCode(ResultCode resultCode) {
		this.code = resultCode.getCode();
		this.msg = resultCode.getMsg();
	}

	protected void setData(Object data) {
		this.data = data;
	}

	public static Result success() {
		Result result = new Result();
		result.setResultCode(ResultCode.SUCCESS);
		return result;
	}

	public static Result success(Object data) {
		Result result = new Result();
		result.setResultCode(ResultCode.SUCCESS);
		result.setData(data);
		return result;
	}

	public static Result failure(ResultCode resultCode) {
		Result result = new Result();
		result.setResultCode(resultCode);
		return result;
	}

	public static Result failure(ResultCode resultCode, String detail) {
		Result result = new Result();
		result.setResultCode(resultCode);
		result.setDetail(detail);
		return result;
	}
}
