package cn.quantgroup.big.stms.common.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;

/**
 * <B>描述：</B><BR>
 * 值对象最高基类 <BR>
 *
 * @author rong yang
 * @version 1.0 2013-06-22
 */
@MappedSuperclass

public abstract class BaseVO<ID extends Serializable> extends BaseEntityVO<ID> implements Auditable {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "create_time", updatable = false)
    @CreatedDate
    private Date createTime;

    /**
     * 最近一次更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "update_time")
    @LastModifiedDate
    private Date updateTime;

    /**
     * 更新人员,登录的用户账号
     */
    @Column(name = "update_user")
    private String updateUser;

    /**
     * 创建者的用户,登录的用户账号
     */
    @Column(length = 36, updatable = false)
    private String creator;

    public BaseVO() {
        super();
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(String updateUser) {
        this.updateUser = updateUser;
    }

    public String getCreator() {
        return creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }


}
