package cn.quantgroup.big.stms.common.enums;

import com.google.common.collect.Maps;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * @Describe: 租户枚举
 * @Created by tangfeng 2021/11/15 10:38 上午
 */
@Getter
@AllArgsConstructor
@NoArgsConstructor
public enum TenantEnum {
    KDSP(560761, "羊小咩"),
    QING_HAI_MOBILE(560867, "青海移动"),
    JIANG_SU_MOBILE(560868, "江苏移动"),
    ;
    private Integer tenantId;
    private String desc;

    private static Map<Integer,TenantEnum> tenantIdEnumMap = Maps.newHashMap();
    static {
        for (TenantEnum value : TenantEnum.values()) {
            tenantIdEnumMap.put(value.tenantId, value);
        }
    }
}
