package cn.quantgroup.big.stms.common.context;

import java.util.HashMap;
import java.util.Map;

public class AppContextHolder {
	/**当前用户**/
	private final static String ONLINE_USER_INFO = "CURRENT_ONLINE_USER_INFO";//当前用户信息

	private static ThreadLocal<Map<String, Object>> context = new ThreadLocal<>();

	private static void set(String key, Object value) {
		Map<String, Object> map = context.get();
		if (map == null) {
			map = new HashMap<String, Object>();
			context.set(map);
		}
		map.put(key, value);
	}

	private static Object get(String key) {
		Map<String, Object> map = context.get();
		if (map == null) {
			map = new HashMap<String, Object>();
			context.set(map);
		}
		return map.get(key);
	}

	public static void setOnlineUser(OnlineUser onlineUser) {
		set(ONLINE_USER_INFO, onlineUser);
	}

	public static OnlineUser getOnlineUser() {
		return (OnlineUser) get(ONLINE_USER_INFO);
	}
	
	public static void remove() {
		context.remove();
	}

}
