package cn.quantgroup.big.stms.common.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.mail.*;
import java.util.Properties;


@Component
public class EmailAuthentication implements IAuthentication{
    private static Logger logger = LoggerFactory.getLogger(EmailAuthentication.class);
    private static final int TIMEOUT = 10000;
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int WRITE_TIMEOUT = 10000;

    /**
     * 通过邮件系统，验证用户名密码的合法性
     *
     * @param username
     * @param password
     * @return
     */
    @Override
    public boolean authenticate(final String username, final String password) {
        //新邮箱服务
        String u = username.endsWith("@quantgroup.cn") ? username : username + "@quantgroup.cn";
        Properties props = new Properties();
        props.put("mail.debug", "false");
        props.put("mail.smtp.timeout", TIMEOUT);//milliseconds
        props.put("mail.smtp.connectiontimeout", CONNECTION_TIMEOUT);
        props.put("mail.smtp.writetimeout", WRITE_TIMEOUT);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.host", "mail.quantgroup.cn"); // smtp主机名。
        props.put("mail.smtp.port", "587");

        boolean success = authenticate(u, password, props);

        return success;

    }

    /**
     * <p>
     * description: 邮件服务器认证
     * </p>
     *
     * @param
     * @return
     * @author rong.yang/阳荣
     */
    private boolean authenticate(final String username, final String password, final Properties props) {
        boolean success = false;

        // 邮件用户名密码认证。
        Authenticator authenticator = new Authenticator() {
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        };

        Session session = Session.getInstance(props, authenticator);
        Transport transport = null;
        try {
            transport = session.getTransport("smtp");
            transport.connect();
            success = true;
        } catch (NoSuchProviderException e) {
            logger.warn("通过邮箱账户登录失败：" + e.getMessage());
        } catch (javax.mail.MessagingException e) {
            logger.warn("通过邮箱账户登录失败：" + e.getMessage());
        } finally {
            if (null != transport) {
                try {
                    transport.close();
                } catch (javax.mail.MessagingException e) {
                    logger.warn("通过邮箱账户登录失败：" + e.getMessage());
                }
            }
        }
        return success;
    }
}
