package cn.quantgroup.big.stms.sys.service.impl;

import cn.quantgroup.big.stms.common.service.impl.BaseTreeServiceImpl;
import cn.quantgroup.big.stms.sys.dao.DictDao;
import cn.quantgroup.big.stms.sys.model.Dict;
import cn.quantgroup.big.stms.sys.service.DictService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class DictServiceImpl extends BaseTreeServiceImpl<Dict, Integer> implements DictService {
    @Autowired
    private DictDao dictDao;

    @Override
    public DictDao getRepository() {
        return dictDao;
    }

    @Override
    public List<Dict> findAllChild(Integer parentId) {
        List<Dict> dictList = getChildren(String.valueOf(parentId));
        List<Dict> result = Lists.newArrayList();
        for (Dict dict : dictList) {
            result.add(dict);
            result.addAll(findAllChild(dict.getId()));
        }
        return result;
    }

    @Override
    public Dict findByCodeAndDegree(String code, Integer degree) {
        return dictDao.findByCodeAndDegree(code, degree);
    }

}
