package cn.quantgroup.big.stms.sys.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;

/**
 * 第三方用户表
 */
@Entity
@Table(name = "t_sys_user_external")
@Data
public class UserExternal {

  @Id
  @Column(name = "id")
  @GenericGenerator(name = "jpa-uuid", strategy = "org.hibernate.id.UUIDGenerator")
  @GeneratedValue(generator = "jpa-uuid")
  private String id;

  /**
   * 用户ID
   */
  private String userId;
  /**
   * 第三方unionId
   */
  private String unionId;
  /**
   * 第三方openId
   */
  private String openId;
  /**
   * 第三方sessionKey
   */
  private String sessionKey;
  /**
   * 手机号码
   */
  private String phone;
  /**
   * 供应商code
   */
  private String supplierCode;
  /**
   * 状态 1:保存,2:有效,3:无效
   */
  private Integer state;

  /**
   * 第三方应用id
   */
  private String appId;
  /**
   * 住户id
   */
  private Integer tenantId;
}
