package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.common.model.BaseTreeVO;
import cn.quantgroup.big.stms.sys.enums.ValueType;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;

import javax.persistence.*;

@Entity
@Table(name = "t_bd_dict")
public class Dict extends BaseTreeVO<Dict,Integer> {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private Dict parent;

    /**
     * 属性编码
     */
    @Column(name = "other", length = 32)
    private String other;

    /**
     * 数据类型
     */
    @Type(type = "cn.quantgroup.big.stms.common.hibernate.usertype.UserEnumType",
            parameters = {@org.hibernate.annotations.Parameter(name = "enumClass", value = "cn.quantgroup.big.stms.sys.enums.ValueType")})
    @Column(name = "type", columnDefinition = "int")
    private ValueType type;

    

    @Override
	public Dict getParent() {
		return parent;
	}

	@Override
	public void setParent(Dict parent) {
		this.parent = parent;
	}

	@Override
    public Integer getId() {
        return id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }


    public String getOther() {
        return other;
    }

    public void setOther(String other) {
        this.other = other;
    }

    public ValueType getType() {
        return type;
    }

    public void setType(ValueType type) {
        this.type = type;
    }
}
