package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.sys.enums.ConfigType;
import lombok.Data;
import org.hibernate.annotations.Type;

import javax.persistence.*;

/**
 * 第三方账户配置信息表
 */
@Entity
@Table(name = "t_sys_config_external")
@Data
public class Config {

  /**
   * 主键
   */
  @Id
  @Column(name = "id")
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private Integer id;


  /**
   * 第三方应用类型
   */
  @Type(type = "cn.quantgroup.big.stms.common.hibernate.usertype.UserEnumType",
      parameters = {@org.hibernate.annotations.Parameter(name = "enumClass", value = "cn.quantgroup.big.stms.sys.enums.ConfigType")})
  @Column(name = "type", columnDefinition = "int")
  private ConfigType type;

  /**
   * 第三方app_id
   */
  private String appId;

  private String secret;

  private Integer tenantId;

}
