package cn.quantgroup.big.stms.sys.job;

import cn.quantgroup.big.stms.sys.dao.ConfigDao;
import cn.quantgroup.big.stms.sys.model.Config;
import cn.quantgroup.big.stms.sys.service.v2.strategy.AccountStrategy;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * 第三方配置token获取job
 */
@Slf4j
@JobHandler("configExternalJob")
@Component
@AllArgsConstructor
public class ConfigExternalJob extends IJobHandler {

  private final AccountStrategy accountStrategy;

  private final ConfigDao configDao;

  @Override
  public ReturnT<String> execute(String s) {
    Pageable pageRequest = new PageRequest(0, 20);
    Page<Config> result;
    do {
      result = configDao.findAll(pageRequest);
      result.forEach(accountStrategy::reloadExternalAccessToken);
      pageRequest = new PageRequest(pageRequest.getPageNumber() + 1, 20);
    } while (result.getTotalPages() >= pageRequest.getPageNumber());
    return ReturnT.SUCCESS;
  }
}
