package cn.quantgroup.big.stms.sys.config;

import cn.quantgroup.big.stms.common.interceptor.CorsInterceptor;
import cn.quantgroup.big.stms.sys.interceptor.TokenInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
public class InterceptorConfig extends WebMvcConfigurerAdapter {

	@Autowired
	private TokenInterceptor tokenInterceptor;
	public void addInterceptors(InterceptorRegistry registry) {
		// 跨域拦截器需放在最上面
        registry.addInterceptor(new CorsInterceptor()).addPathPatterns("/**");
        // 校验token的拦截器
		registry.addInterceptor(tokenInterceptor).addPathPatterns("/**")
				.excludePathPatterns("/home/**","/v1/oauth2/**","/v2/external/getCode","/v2/oauth/bindingCode","/v2/oauth/login","/v2/user/captcha","/v2/oauth/wechat/login","/v2/oauth/refreshtoken","/oauth/captcha","/oauth/login","/oauth/refreshtoken","/settle/task/**","/tenant/list");
		super.addInterceptors(registry);
	}
}
