package cn.quantgroup.big.stms.common.utils;

import cn.quantgroup.security.AESEncryption;
import cn.quantgroup.security.CipherUtil;
import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import org.apache.commons.lang3.StringUtils;

public class AESUtils {
    public static AESEncryption encryption;
    public static String encrypt(final String plainValue) {
        if(StringUtils.isNotEmpty(plainValue) && !CipherUtil.isCipherBase64((plainValue))){
            return encryption().encryptBase64(plainValue);
        }
        return plainValue;
    }
    public static String decrypt(String cipherValue){
        return StringUtils.isNotEmpty(cipherValue) && CipherUtil.isCipherBase64(cipherValue)?encryption().decryptBase64(cipherValue):cipherValue;
    }

    public static AESEncryption encryption() {
        if (encryption == null) {
            Config config = ConfigService.getAppConfig();
            String key = config.getProperty("encrypt.key","");
            String iv = config.getProperty("encrypt.iv","");
            encryption = new AESEncryption(key, iv, true);
        }
        return encryption;
    }
}
