package cn.quantgroup.big.stms.common.service.impl;

import cn.quantgroup.big.stms.common.enums.BasicDataStatus;
import cn.quantgroup.big.stms.common.model.BaseBasicDataVO;
import cn.quantgroup.big.stms.common.service.BasicDataService;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Sort.Direction;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseBasicDataServiceImpl<T extends BaseBasicDataVO<ID>, ID extends Serializable> extends BaseServiceImpl<T, ID> implements BasicDataService<T, ID> {

    /**
     * 分页排序：创建时间-倒序，排序号-倒序
     *
     * @return
     */
    public Sort getSort() {
        List<Sort.Order> orders = new ArrayList<>();
        Sort.Order order1 = new Sort.Order(Direction.DESC, "sortNo");
        Sort.Order order2 = new Sort.Order(Direction.DESC, "createTime");
        orders.add(order1);
        orders.add(order2);
        return new Sort(orders);
    }
    /**
     * 分页排序：创建时间-升序，排序号-倒序
     *
     * @return
     */
    public Sort getSortByCreateTimeAES() {
        List<Sort.Order> orders = new ArrayList<>();
        Sort.Order order1 = new Sort.Order(Direction.DESC, "sortNo");
        Sort.Order order2 = new Sort.Order(Direction.ASC, "createTime");
        orders.add(order1);
        orders.add(order2);
        return new Sort(orders);
    }
	/**
	 * * <p>date: 2019年10月16日 下午6:34:46</p>
	 * <p>
	 * description: 获取所有的有效对象
	 * </p>
	 * 
	 * @author rong.yang/阳荣
	 * @param
	 * @return
	 */

	public List<T> getValidObject() {
	    
		return findAll(new Specification<T>() {
			@Override
			public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				return cb.equal(root.get("status"), BasicDataStatus.VALID);
			}
		},new Sort(Direction.ASC, "sortNo"));
	}

	public void submit(ID id) {
		T entity = getOne(id);
		submit(entity);
	}

	public void submit(T entity) {
	    check(entity);
		beforeSubmit(entity);
		entity.setStatus(BasicDataStatus.VALID);
		save(entity);
		afterSubmit(entity);
	}

	public T findByCode(String code) {
		return findOne(new Specification<T>() {
			@Override
			public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				return cb.equal(root.get("code"), code);
			}
		});
	}

	public T  findByName(String name){
		return findOne(new Specification<T>() {
			@Override
			public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				return cb.equal(root.get("name"), name);
			}
		});
	}

	public T findByCodeAndParentId(String code,ID parentId) {
		return findOne(new Specification<T>() {
			@Override
			public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				Predicate p1 = cb.equal(root.get("code"), code);
				
				Predicate p2 = null;
				if(null == parentId) {
					p2 = cb.isNull(root.get("parent").get("id"));
				}else {
					p2 = cb.equal(root.get("parent").get("id"), parentId);
				}
				
				return cb.and(p1,p2);
			}
		});
	}

	/**
	 * 启用
	 * @param id
	 */
	public void enabled(ID id) {
		T entity = getOne(id);
		enabled(entity);
	}

	/**
	 * 启用
	 * @param entity
	 */
	public void enabled(T entity) {
		beforeSubmit(entity);
		entity.setStatus(BasicDataStatus.VALID);
		save(entity);
		afterSubmit(entity);
	}
	
	/**
	 * 
	 * <p>date: 2019年10月16日 下午6:34:46</p>
	 * <p>description:  禁用</p>
	 * @author rong.yang/阳荣
	 * @param
	 * @return
	 */
	public void disabled(ID id) {
        T entity = getOne(id);
        disabled(entity);
    }

	/**
	 * 
	 * <p>date: 2019年10月16日 下午6:34:46</p>
	 * <p>description:  禁用</p>
	 * @author rong.yang/阳荣
	 * @param
	 * @return
	 */
    public void disabled(T entity) {
        beforeSubmit(entity);
        entity.setStatus(BasicDataStatus.INVALID);
        save(entity);
        afterSubmit(entity);
    }
	
	
    /**
     * 
     * <p>date: 2019年10月16日 下午6:34:46</p>
     * <p>description:  提交时检查数据</p>
     * @author rong.yang/阳荣
     * @param
     * @return
     */
	protected void check(T vo) {

	}
	

	protected void beforeSubmit(T entity) {

	}

	protected void afterSubmit(T entity) {

	}

	/**
	 * 新增时设置状态
	 * @param entity
	 */
	protected void setAddNew(T entity) {
		super.setAddNew(entity);
		entity.setStatus(BasicDataStatus.SAVE);
	}
}
