package cn.quantgroup.big.stms.common.context;

import com.google.gson.Gson;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
public class OnlineUser implements Serializable {

  /**
   * 用户ID
   **/
  private String id;
  /**
   * 登录账号
   **/
  private String account;
  /**
   * 用户显示名称
   **/
  private String name;

  /**
   * 用户所属组织ID
   **/
  private String orgId;

  /**
   * 用户所属组织名称
   **/
  private String orgName;

  /**
   * 登录IP
   **/
  private String loginIp;
  /**
   * 租户id
   */
  private String tenantIds;

  /**
   * 账户类型，默认值为0，原有账户分配用户；如果是第三方登录用户，值为1
   */
  private int accountType;

  private String supplierCode;

  private String permissions;

  /**
   * 是否绑定了第三方账户
   */
  private boolean bindStatus = false;

  public OnlineUser(String id, String account, String name, String orgId, String orgName,
      String loginIp, String tenantIds,String supplierCode,String permissions) {
    this(id,account,name,orgId,orgName,loginIp,tenantIds,supplierCode,0);
    this.permissions= permissions;
  }

  public OnlineUser(String id, String account, String name, String orgId, String orgName,
      String loginIp, String tenantIds,String supplierCode) {
    this(id,account,name,orgId,orgName,loginIp,tenantIds,supplierCode,0);
  }

  public OnlineUser(String id, String account, String name, String orgId, String orgName,
      String loginIp, String tenantIds, String supplierCode,int accountType) {
    super();
    this.id = id;
    this.account = account;
    this.name = name;
    this.orgId = orgId;
    this.orgName = orgName;
    this.loginIp = loginIp;
    this.tenantIds = tenantIds;
    this.accountType = accountType;
    this.supplierCode = supplierCode;
  }

  public OnlineUser(String json) {
    Gson gson = new Gson();
    OnlineUser user = gson.fromJson(json,OnlineUser.class);
    this.setId(user.getId());
    this.setAccount(user.getAccount());
    this.setName(user.getName());
    this.setOrgId(user.getOrgId());
    this.setOrgName(user.getOrgName());
    this.setLoginIp(user.getLoginIp());
    this.setSupplierCode(user.getSupplierCode());
    this.setAccountType(user.getAccountType());
    this.setBindStatus(user.isBindStatus());
    this.setTenantIds(user.getTenantIds());
  }

  public String getId() {
    return id;
  }

  public String getAccount() {
    return account;
  }

  public String getName() {
    return name;
  }

  public String getOrgId() {
    return orgId;
  }

  @Override
  public String toString() {
    return name;
  }

  public String toJson() {
    Gson gson = new Gson();
    return gson.toJson(this);
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((id == null) ? 0 : id.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }

    if (obj == null) {
      return false;
    }

    if (getClass() != obj.getClass()) {
      return false;
    }

    OnlineUser other = (OnlineUser) obj;
    if (id == null) {
      if (other.id != null) {
        return false;
      }
    } else if (!id.equals(other.id)) {
      return false;
    }

    return true;
  }
}
