package cn.quantgroup.big.stms.common.config;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import java.util.Hashtable;

/**
 * ldap 用户认证
 *
 * @author axq
 */
@Component
@Slf4j
public class LDAPAuthentication implements IAuthentication {
    private static final String LDAP_URL = "ldap://ldap.quantgroups.com:389/";
    private static final String BIND_DN = "cn=common_auth_query,cn=users,DC=quantgroup,DC=cn";
    private static final String BIND_CREDENTIALS = "Quantgroup.com@2o17";
    private static final String SEARCH_BASE = "ou=北京量科邦信息技术有限公司,dc=quantgroup,dc=cn";

    private Control[] connCtls = null;

    public LdapContext getCtx() {
        LdapContext ctx = null;
        Hashtable<String, String> env = new Hashtable();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.ldap.LdapCtxFactory");
        env.put(Context.PROVIDER_URL, LDAP_URL + SEARCH_BASE);
        env.put(Context.SECURITY_AUTHENTICATION, "simple");
        env.put(Context.SECURITY_PRINCIPAL, BIND_DN);
        env.put(Context.SECURITY_CREDENTIALS, BIND_CREDENTIALS);
        try {
            // 链接ldap
            ctx = new InitialLdapContext(env, connCtls);
            log.info("ldap 链接成功");
        } catch (AuthenticationException e) {
            log.error("认证失败");
        } catch (Exception e) {
            log.error("认证出错：");
            e.printStackTrace();
        }
        return ctx;
    }



    @Override
    public boolean authenticate(String username, String password) {
        boolean valide = false;
        String email = username.endsWith("@quantgroup.cn") ? username : username + "@quantgroup.cn";
        String userDN = "";
        LdapContext ctx = getCtx();
        if (ctx != null) {
            try {
                SearchControls constraints = new SearchControls();
                constraints.setSearchScope(SearchControls.SUBTREE_SCOPE);
                NamingEnumeration en = ctx.search("", "mail=" + email, constraints);
                while (en.hasMoreElements()) {
                    Object obj = en.nextElement();
                    if (obj instanceof SearchResult) {
                        SearchResult si = (SearchResult) obj;
                        userDN = userDN + si.getName();
                        userDN += "," + SEARCH_BASE;
                    }
                }
            } catch (Exception e) {
                log.error("Exception in search():" + e);
                e.printStackTrace();
            }
        }
        if(StringUtils.isNotBlank(userDN)) {
            try {
                ctx.addToEnvironment(Context.SECURITY_PRINCIPAL, userDN);
                ctx.addToEnvironment(Context.SECURITY_CREDENTIALS, password);
                ctx.reconnect(connCtls);
                log.info(userDN + " is authenticated");
                valide = true;
            } catch (AuthenticationException e) {
                log.error(userDN + " is not authenticated");
                e.printStackTrace();
                valide = false;
            } catch (NamingException e) {
                log.error(userDN + " is not authenticated");
                valide = false;
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return valide;
    }

}
