package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.common.model.BaseBasicDataVO;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.*;

@Entity
@Table(name = "t_sys_role")
@Data
public class Role extends BaseBasicDataVO<String> {

    @Id
    @Column(name = "id")
    //jpa (hibernate实现)的UUID生成主键策略
    @GenericGenerator(name = "jpa-uuid", strategy = "org.hibernate.id.UUIDGenerator")
    @GeneratedValue(generator = "jpa-uuid") //使用jpa-uuid的生成策略
    private String id;

    /**
     * 应用
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "app_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private App app;

    @Column(name = "tenant_id")
    private Integer tenantId;

    @Transient
    private String tenantName;

    @Column(name = "organization_id")
    private String organizationId;


    // 0 未选中 1选中
    @Transient
    private Integer selected;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

}
