package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.common.model.BaseBasicDataVO;
import lombok.Data;

import javax.persistence.*;
import java.util.List;

/**
 * @Author meng.xin@quantgroup.cn
 * @Date 2020-01-06 15:53
 * @Version 1.0
 */
@Entity
@Table(name = "t_sys_app")
@Data
public class App extends BaseBasicDataVO<Integer> {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;

    /**
     * 秘钥
     */
    @Column(name = "appsecret")
    private String appsecret;

    /**
     * 用于量星球返回用户当前系统的所有角色
     */
    @Transient
    private List<String> roles;

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }
}
