package cn.quantgroup.big.stms.sys.enums;

import cn.quantgroup.big.stms.common.enums.BaseEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author aoxq
 * @date 2019/12/3 11:29
 **/
@AllArgsConstructor
@Getter
public enum ValueType implements BaseEnum<Integer> {
    STRING("字符串", 1),
    INTEGER("整数", 2);

    private String name;
    private Integer value;

    @JsonCreator
    public static ValueType get(int v) {
        for (ValueType e : values()) {
            if (e.getValue().equals(v)) {
                return e;
            }
        }
        return null;
    }
}
