package cn.quantgroup.big.stms.sys.controller.v2;

import cn.quantgroup.big.stms.sys.dao.ConfigDao;
import cn.quantgroup.big.stms.sys.model.Config;
import cn.quantgroup.big.stms.sys.service.remote.WechatRemoteService;
import cn.quantgroup.big.stms.sys.service.remote.model.CodeUnlimitVo;
import cn.quantgroup.big.stms.sys.utils.ConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/v2/external")
public class ExternalV2Controller {

  @Autowired
  private WechatRemoteService wechatRemoteService;

  @Autowired
  private  ConfigDao configDao;

  @Autowired
  private  ConfigUtils configUtils;


  @PostMapping(value = "/getCode",produces = MediaType.IMAGE_JPEG_VALUE)
  public @ResponseBody byte[] getWxaCodeUnlimit(@RequestParam("appId")String appId,@RequestParam("tenantId")Integer tenantId){
    Config config = configDao.findByTenantIdAndAppId(tenantId, appId);
    CodeUnlimitVo  vo = new CodeUnlimitVo();
    vo.setPage("pages/index/index");
    vo.setScene("a=1");
    vo.setCheck_path(true);
    vo.setEnv_version("release");
    return wechatRemoteService.getWxaCodeUnlimit(configUtils.getExternalAccessToken(config.getId()),vo);
  }

}
