package cn.quantgroup.big.stms.common.service.impl;

import cn.quantgroup.big.stms.common.context.AppContextHolder;
import cn.quantgroup.big.stms.common.model.BaseAssociatedVO;
import cn.quantgroup.big.stms.common.service.AssociatedService;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xinm
 * @create 2019-10-30
 **/
public abstract class BaseAssociatedServiceImpl<T extends BaseAssociatedVO<ID>, ID extends Serializable> extends BaseEntityServiceImpl<T, ID> implements AssociatedService<T, ID> {

    protected void beforeSave(T entity) {
        entity.setCreateTime(new Date());
        entity.setCreator(AppContextHolder.getOnlineUser() ==  null ? null : AppContextHolder.getOnlineUser().getAccount());
    }

}
