package cn.quantgroup.big.stms.common.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;

/**
 * @author ouyangjie
 * @create 2019-10-29 下午 4:44
 **/
@MappedSuperclass
public abstract class BaseAssociatedVO<ID extends Serializable> extends BaseEntityVO<ID> {
    private static final long serialVersionUID = 1L;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "create_time", updatable = false)
    @CreatedDate
    private Date createTime;

    /**
     * 创建者的用户,登录的用户账号
     */
    @Column(length = 36, updatable = false)
    private String creator;

    public BaseAssociatedVO() {
        super();
    }


    public Date getCreateTime() {
        return createTime;
    }


    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }


    public String getCreator() {
        return creator;
    }


    public void setCreator(String creator) {
        this.creator = creator;
    }
}
