package cn.quantgroup.big.stms.common.exception;

import cn.quantgroup.big.stms.common.result.Result;
import cn.quantgroup.big.stms.common.result.ResultCode;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import java.util.Set;

@Slf4j
@RestControllerAdvice
public class GlobalExceptionHandler {

	@ExceptionHandler(value = { ConstraintViolationException.class })
	public Object constraintViolationHandle(ConstraintViolationException e) {
		log.warn("参数校验错误！",e);
		Set<ConstraintViolation<?>> violations = e.getConstraintViolations();
		if (violations != null) {
			StringBuilder buffer = new StringBuilder();
			for (ConstraintViolation<?> constraintViolation : violations) {
				if (constraintViolation != null) {
					buffer.append(constraintViolation.getMessage()).append(";");
				}
			}
			return Result.failure(ResultCode.PARAM_ERROR, buffer.toString());
		}
		return Result.failure(ResultCode.PARAM_ERROR);
	}

	@ExceptionHandler(value = { MethodArgumentNotValidException.class })
	public Object validHandle(MethodArgumentNotValidException e) {
		log.warn("方法参数校验错误！",e);
		BindingResult result = e.getBindingResult();
		if (result != null && result.getAllErrors() != null) {
			StringBuilder buffer = new StringBuilder();
			for (ObjectError error : result.getAllErrors()) {
				buffer.append(error.getDefaultMessage()).append(";");
			}
			return Result.failure(ResultCode.PARAM_ERROR, buffer.toString());
		}
		return Result.failure(ResultCode.PARAM_ERROR);
	}

	@ExceptionHandler(value = { BindException.class })
	public Object validHandle(BindException e) {
		log.warn("参数校验错误！",e);
		BindingResult result = e.getBindingResult();
		if (result != null && result.getAllErrors() != null) {
			StringBuilder buffer = new StringBuilder();
			for (ObjectError error : result.getAllErrors()) {
				buffer.append(error.getDefaultMessage()).append(";");
			}
			return Result.failure(ResultCode.PARAM_ERROR, buffer.toString());
		}
		return Result.failure(ResultCode.PARAM_ERROR);

	}

	@ExceptionHandler(value = { BizException.class })
	public Object bizExceptionHandle(BizException e) {
		log.error("业务处理异常！", e);
		ResultCode resultCode = e.getResultCode();
		if (null != resultCode) {
			return Result.failure(resultCode, e.getMessage());
		} else {
			return Result.failure(ResultCode.SERVICE_ERROR, e.getMessage());
		}

	}

	@ExceptionHandler(value = { Throwable.class })
	public Object errorHandle(Exception e) {
		log.error("服务器异常！", e);
		return Result.failure(ResultCode.SERVICE_ERROR, e.getMessage());
	}

}