package cn.quantgroup.big.stms.common.aviator.ext.function;

import com.googlecode.aviator.AviatorEvaluator;
import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;

/**
 * 
 * <p>
 * description: 计算指定日期所在月份的月份差
 * </p>
 * 
 * @author rong.yang/阳荣
 *
 */
public class MonthsDiffFunction extends AbstractFunction {
	@Override
	public AviatorObject call(Map<String, Object> env, AviatorObject date) {
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
		String sd1 = FunctionUtils.getStringValue(date, env);
		if(null == sd1 || 0 == sd1.trim().length()) {
			throw new ExpressionRuntimeException(getName() + "函数参数不能为空！");
		}

		LocalDate date1 = LocalDate.parse(sd1, formatter);
		LocalDate date11 =  LocalDate.of(date1.getYear(), date1.getMonth(), 1);
		
		LocalDate now = LocalDate.now();
		long months = ChronoUnit.MONTHS.between(date11, LocalDate.of(now.getYear(), now.getMonth(), 1));

		return AviatorLong.valueOf(months);
	}
	
	@Override
	public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
		String sd1 = FunctionUtils.getStringValue(arg1, env);
		if(null == sd1 || 0 == sd1.trim().length()) {
			throw new ExpressionRuntimeException(getName() + "函数参数不能为空！");
		}
		
		String sd2 = FunctionUtils.getStringValue(arg2, env);
		if(null == sd2 || 0 == sd2.trim().length()) {
			throw new ExpressionRuntimeException(getName() + "函数参数不能为空！");
		}
		

		LocalDate date1 = LocalDate.parse(sd1, formatter);
		LocalDate date11 =  LocalDate.of(date1.getYear(), date1.getMonth(), 1);
		
		LocalDate date2 = LocalDate.parse(sd2, formatter);
		LocalDate date22 =  LocalDate.of(date2.getYear(), date2.getMonth(), 1);

		long months = ChronoUnit.MONTHS.between(date11, LocalDate.of(date22.getYear(), date22.getMonth(), 1));

		return AviatorLong.valueOf(months);
	}

	public String getName() {
		return "date.monthsDiff";
	}

	public static void main(String[] args) {
		AviatorEvaluator.addFunction(new MonthsDiffFunction());
		Map map = new HashMap();
		map.put("a", "2019-10-05");
		Object rs = AviatorEvaluator.execute("date.monthsDiff(a,'2019-11-03')", map);
		System.out.println(rs);
	}
}
