package cn.quantgroup.big.stms.sys.utils;

import cn.quantgroup.big.stms.common.context.AppContextHolder;
import cn.quantgroup.big.stms.common.context.OnlineUser;
import cn.quantgroup.big.stms.common.exception.BizException;
import cn.quantgroup.big.stms.common.result.ResultCode;
import cn.quantgroup.big.stms.sys.model.Role;
import cn.quantgroup.big.stms.sys.model.User;
import org.apache.commons.lang3.StringUtils;

public class PermissionUtils {

  /**
   * 暂时只需要同一个组织结构的账户才能删除，相当供应链的主账户， 后续对stms进行权限控制，可以让有权限对才允许调用
   *
   * @param user 需要被操作的账户
   */
  public static boolean checkMaster(User user) {
    OnlineUser current = AppContextHolder.getOnlineUser();
    //被删除的账户必须是某个组织下
    if (user.getOrganization() == null) {
      throw new BizException("只有主账户才能删除", ResultCode.FORBIDDEN);
    }
    //说明该账户是后台超级管理员
    if (StringUtils.isEmpty(current.getOrgId())) {
      return true;
    }
    //只允许上级账户删除下级，或者同级间进行操作
    if (user.getOrganization().getId().equals(current.getOrgId()) ||
        (user.getOrganization().getParent() != null && user.getOrganization().getParent().getId()
            .equals(current.getOrgId()))) {
      return true;
    } else {
      throw new BizException("只有主账户才能进行该操作", ResultCode.FORBIDDEN);
    }

  }

  public static boolean checkMaster(Role role) {
    OnlineUser current = AppContextHolder.getOnlineUser();
    //说明该账户是后台超级管理员
    if (StringUtils.isEmpty(current.getOrgId())) {
      return true;
    }
    if (role.getOrganizationId() != null && role.getOrganizationId().equals(current.getOrgId())) {
      return true;
    } else {
      throw new BizException("只有主账户才能删除", ResultCode.FORBIDDEN);
    }
  }

}
