package cn.quantgroup.big.stms.sys.service.impl;

import cn.quantgroup.big.stms.common.model.Supplier;
import cn.quantgroup.big.stms.common.service.impl.BaseTreeServiceImpl;
import cn.quantgroup.big.stms.sys.dao.OrganizationDao;
import cn.quantgroup.big.stms.sys.dao.V2.OrganizationV2Dao;
import cn.quantgroup.big.stms.sys.model.Organization;
import cn.quantgroup.big.stms.sys.service.OrganizationService;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Example;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class OrganizationServiceImpl extends BaseTreeServiceImpl<Organization, String> implements OrganizationService {

    @Value("${keystone-operation.https}")
    private String KEYSTONE_OPERATION_HTTPS;

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    /**
     * 通过名称获取供应商详情
     */
    private static final String FIND_SUPPLIER_BY_NAME_URL="/channel/supplier/findSupplierByName";
    @Autowired
    private OrganizationDao organizationDao;

    @Autowired
    private OrganizationV2Dao organizationV2Dao;

    private final static String ORGANIZATION_KEY = "stms:supply:chain:organization:";

    /**
     * 组织信息过期时间 单位秒
     **/
    private final static long ORGANIZATION_EXPIRE = 120;

    @Override
    public OrganizationDao getRepository() {
        return organizationDao;
    }

    /**
            * 校验供应链中商户存在不存在
     * @param accessToken
     * @param name
     * @return
             */
    public String validateSupplierName(String accessToken,String name){
        String  path = KEYSTONE_OPERATION_HTTPS+FIND_SUPPLIER_BY_NAME_URL;
        // 1 创建okhttp客户端对象
        OkHttpClient client  = new OkHttpClient();
        RequestBody body = new FormBody.Builder()
                .add("name",name).build();
        // 2 request 默认是get请求
        Request request = new  Request.Builder()
                .addHeader("access-token", accessToken)
                .post(body)
                .url(path)
                .build();
        // 3 进行请求操作
        try {
            Response response = client.newCall(request).execute();
            // 4 判断是否请求成功
            if(response.isSuccessful()){
                // 得到响应体中的身体,将其转成  string
                String string = response.body().string();
                log.info("[stms][OrganizationServiceImpl][validateSupplierName]调用供应链接口={},response={}",path,string);
                JSONObject object = JSONObject.parseObject(string);
                Object businessCode = object.get("businessCode");
                if("0000".equals(businessCode)){
                    Object data = object.get("data");
                    if(Objects.nonNull(data)){
                        Supplier supplier = JSONObject.parseObject(data.toString(), Supplier.class);
                        if(Objects.nonNull(supplier)){
                            return supplier.getSupplierCode();
                        }
                    }
                }
            }else{
                log.info("[stms][OrganizationServiceImpl][validateSupplierName]调用供应链接口={},response={}",path,JSONObject.toJSONString(response));
            }

        } catch (IOException e) {
            log.error("[stms][OrganizationServiceImpl][validateSupplierName]查询供应链商户存在不存在:",e);
        }
        return "";

    }

    @Override
    public List<Organization> findBySupplierCode(String supplierCode) {
        Organization organization = new Organization();
        organization.setSupplierCode(supplierCode);
        Example<Organization> query = Example.of(organization);
        return organizationDao.findAll(query);
    }

    @Override
    public Boolean validateIsSupplyMerchant(String orgId) {
        String key  =ORGANIZATION_KEY+orgId;
        String organizationstr = stringRedisTemplate.opsForValue().get(key);
        Organization org;
        if(StringUtils.isNotEmpty(organizationstr)){
            org = JSONObject.parseObject(organizationstr,Organization.class);
        }else{
            org = findById(orgId);
            stringRedisTemplate.opsForValue().set(key,JSONObject.toJSONString(org),ORGANIZATION_EXPIRE, TimeUnit.SECONDS);
        }
        // 是供给供应链的 判断是否是商户用户
        if(Objects.nonNull(org.getParent())
                && ("a6ed0680-849d-4821-bb8e-c3398ddb1b5a".equals(org.getParent().getId())
                || "a6ed0680-849d-4821-bb8e-c3398ddb1b5a".equals(orgId))){
            return true;
        }
        return false;
    }

    @Override
    public Organization saveAndSubmit(Organization organization) {
        save(organization);
        submit(organization);
        return organization;
    }

    @Override
    public List<Organization> findAllByParentId(String parentId) {
        return organizationV2Dao.findAllByParentId(parentId);
    }
}
