package cn.quantgroup.big.stms.sys.enums;

import cn.quantgroup.big.stms.common.enums.BaseEnum;

public enum ConfigType implements BaseEnum<Integer> {
  WECHAT_MINI("微信小程序", 1),
  ALIPAY("支付宝小程序", 5);

  private final String name;
  private final Integer value;

  ConfigType(String name, Integer value) {
    this.name = name;
    this.value = value;
  }

  @Override
  public Integer getValue() {
    return value;
  }

  @Override
  public String getName() {
    return name;
  }
}

