package cn.quantgroup.big.stms.sys.dto;

import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Data
public class RedashFormDto {
    /**
     * 报表id
     **/
    private Integer id;

    /**
     * 报表名称
     */
    @NotBlank(message = "报表名称不能为空")
    @Size(min = 1, max = 255, message = "名称长度必须在{min}-{max}之间")
    private String name;

    /**
     * 报表查询id
     */
    @NotNull(message = "报表查询id不能为空")
    @Min(value = 1, message = "排序号不能小于{value}")
    private Integer queryId;

    /**
     * 报表url
     */
    @NotBlank(message = "报表url不能为空")
    private String formUrl;

    /**
     * 文档url
     */
    @NotBlank(message = "报表文档url不能为空")
    private String docUrl;

}
