package cn.quantgroup.big.stms.sys.dao;

import cn.quantgroup.big.stms.common.dao.BaseRepository;
import cn.quantgroup.big.stms.sys.model.UserExternal;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public interface UserExternalDao extends BaseRepository<UserExternal, String> {

  UserExternal findByTenantIdAndAppIdAndPhone(int tenantId, String appId, String phone);

  @Modifying
  @Query("update UserExternal u set u.supplierCode = ?2 where u.id = ?1")
  int bindSupplierCode(String id, String supplierCode);

  @Modifying
  @Query("update UserExternal u set u.userId = ?2 where u.id = ?1")
  int updateUserId(String id, String userId);


  UserExternal findByUserId(String userId);

}
