package cn.quantgroup.big.stms.common.service;

import javax.mail.MessagingException;

/**
 * @Author meng.xin@quantgroup.cn
 * @Date 2020-01-13 11:50
 * @Version 1.0
 */
public interface MailService {
    /**
     * 简单的文本邮件
     *
     * @param to      收件人地址
     * @param subject 主题
     * @param content 内容
     */
    void sendSimpleMail(String to, String subject, String content);

    /**
     * 富文本邮件
     * MimeMessageHelper支持发送复杂邮件模板，支持文本、附件、HTML、图片等。
     *
     * @param to      收件人地址
     * @param subject 主题
     * @param content 内容
     * @param rscPath 资源路径
     * @param rscId   资源ID
     * @throws MessagingException
     */
    void sendInlineResourceMail(String to, String subject, String content, String rscPath, String rscId) throws MessagingException;
}
