package cn.quantgroup.big.stms.common.service;

import cn.quantgroup.big.stms.common.model.BaseBasicDataVO;

import java.io.Serializable;
import java.util.List;

public interface BasicDataService<T extends BaseBasicDataVO<ID>, ID extends Serializable> extends BaseService<T, ID> {

    public void submit(ID id);

    public void submit(T entity);

    public T findByCode(String code);


    T findByName(String name);

    T findByCodeAndParentId(String code,ID parentId);
    /**
     * 启用
     * @param id
     */
    public void enabled(ID id);

    /**
     * 启用
     * @param entity
     */
    public void enabled(T entity);

    /**
     * 
     * <p>date: 2018年7月23日 下午6:34:46</p>
     * <p>description:  禁用</p>
     * @author rong.yang/阳荣
     * @param
     * @return
     */
    public void disabled(ID id);

    /**
     * 
     * <p>date: 2018年7月23日 下午6:34:58</p>
     * <p>description:  禁用</p>
     * @author rong.yang/阳荣
     * @param
     * @return
     */
    public void disabled(T entity);
    /**
     * 
     * <p>
     * date: 2015年5月23日 下午2:49:01
     * </p>
     * <p>
     * description: 获取所有的有效对象
     * </p>
     * 
     * @author rong.yang/阳荣
     * @param
     * @return
     */

    public List<T> getValidObject();
}