package cn.quantgroup.big.stms.sys.service.v2.strategy;

import cn.quantgroup.big.stms.common.context.OnlineUser;
import cn.quantgroup.big.stms.sys.dao.ConfigDao;
import cn.quantgroup.big.stms.sys.dto.TokenDto;
import cn.quantgroup.big.stms.sys.enums.ConfigType;
import cn.quantgroup.big.stms.sys.model.Config;
import cn.quantgroup.big.stms.sys.service.v2.AccountService;
import cn.quantgroup.big.stms.sys.utils.ConfigUtils;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component
public class AccountStrategy {

  private final Map<ConfigType, AccountService> accountServiceMap = new HashMap<>();
  private final ConfigDao configDao;
  private final ConfigUtils configUtils;

  public AccountStrategy(List<AccountService> accountServices, ConfigDao configDao,
      ConfigUtils configUtils) {
    this.configDao = configDao;
    this.configUtils = configUtils;
    accountServices.forEach(i -> accountServiceMap.put(i.getType(), i));
  }

  public void reloadExternalAccessToken(Config config) {
    accountServiceMap.get(config.getType()).reloadExternalAccessToken();
  }

  public TokenDto loginByCode(String code, String appId, Integer tenantId) {
    Config config = configDao.findByTenantIdAndAppId(tenantId, appId);
    return accountServiceMap.get(config.getType()).loginByCode(code, config);
  }

  /**
   * 刷新访问token
   *
   * @param refreshToken 刷新token
   * @return TokenDto
   */
  public TokenDto refreshToken(String refreshToken) {
    OnlineUser onlineUser = configUtils.getOnlineUserByRefreshToken(refreshToken);

    String accessToken = configUtils.getAccessTokenByUserId(onlineUser.getId());

    TokenDto tokenDto = new TokenDto();
    tokenDto.setAccessToken(accessToken);
    tokenDto.setRefreshToken(refreshToken);
    return configUtils.updateLoginToken(onlineUser, tokenDto);
  }
}
