package cn.quantgroup.big.stms.sys.service.v2.impl;

import cn.quantgroup.big.stms.common.service.PermissionService;
import cn.quantgroup.big.stms.sys.service.PermissionV2Service;
import org.springframework.stereotype.Service;
import org.springframework.util.AntPathMatcher;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@Service
public class PermissionV2ServiceImpl implements PermissionV2Service {

  private final PermissionService permissionService;
  private final AntPathMatcher pathMatcher = new AntPathMatcher();

  public PermissionV2ServiceImpl(PermissionService permissionService) {
    this.permissionService = permissionService;
  }

  @Override
  public boolean checkPermission(Integer tenantId,String userId, List<String> paths) {
    assert paths != null;
    AtomicBoolean result = new AtomicBoolean(false);
    paths.forEach(path -> {
      if (!result.get()) {
        result.set(permissionService.getRegPermission(tenantId,userId).stream()
            .anyMatch(i -> pathMatcher.match(i, path)));

      }
    });

    return result.get();
  }
}
