package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.common.model.BaseAssociatedVO;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.*;

/**
 * @author ouyangjie
 * @create 2019-10-29 下午 4:36
 **/
@Entity
@Table(name = "t_sys_role_resource")
@Data
public class RoleResource extends BaseAssociatedVO<String> {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "id")
    @GenericGenerator(name = "jpa-uuid", strategy = "org.hibernate.id.UUIDGenerator")
    @GeneratedValue(generator = "jpa-uuid") //使用jpa-uuid的生成策略
    private String id;

    /**
     * 角色
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "role_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private Role role;
    /**
     * 资源
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "resource_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private Resource resource;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

}
