package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.common.model.BaseTreeVO;
import cn.quantgroup.big.stms.sys.enums.ResourceType;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Type;

import javax.persistence.*;

@Entity
@Table(name = "t_sys_resource")
@Data
public class Resource extends BaseTreeVO<Resource, String> {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @Id
    @Column(name = "id")
    @GenericGenerator(name = "jpa-uuid", strategy = "org.hibernate.id.UUIDGenerator")
    @GeneratedValue(generator = "jpa-uuid")
    private String id;

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "parent_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private Resource parent;

    /**
     * 应用
     */
    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "app_id")
    @NotFound(action = NotFoundAction.IGNORE)
    private App app;

    /**
     * 图标
     */
    @Column(name = "picture")
    private String picture;

    /**
     * 是否超级管理人资源
     */
    @Column(name = "is_super")
    private Boolean isSuper;

    /**
     * 权限标识
     */
    @Column(name = "permission")
    private String permission;

    /**
     * 资源类型 1:资源组,2:菜单3:功能
     */
    @Type(type = "cn.quantgroup.big.stms.common.hibernate.usertype.UserEnumType",
            parameters = {@org.hibernate.annotations.Parameter(name = "enumClass", value = "cn.quantgroup.big.stms.sys.enums.ResourceType")})
    @Column(name = "type", columnDefinition = "int")
    private ResourceType type;

    /**
     * 资源URI
     */
    @Column(name = "uri")
    private String uri;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Resource getParent() {
        return parent;
    }

    @Override
    public void setParent(Resource parent) {
        this.parent = parent;
    }
}
