package cn.quantgroup.big.stms.sys.dto;

import cn.quantgroup.big.stms.sys.enums.ResourceType;
import cn.quantgroup.big.stms.sys.model.App;
import cn.quantgroup.big.stms.sys.model.Resource;
import lombok.Data;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * @Author meng.xin@quantgroup.cn
 * @Date 2019-10-30 18:31
 * @Version 1.0
 */
@Data
public class ResourceDto {
    /**
     * 资源ID
     **/
    private String id;

    /**
     * 上级资源
     **/
    private Resource parent;

    /**
     * 应用
     **/
    @NotNull(message = "所属应用不为空")
    private App app;

    @NotNull(message = "资源类型不能为空")
    private ResourceType type;

    /**
     * 资源编码
     **/
    @NotNull(message = "资源编码不为空")
    @Size(min = 1, max = 32, message = "资源编码必须在{min}-{max}之间")
    private String code;

    /**
     * 资源名称
     */
    @NotNull(message = "资源名称不为空")
    @Size(min = 1, max = 64, message = "资源名称必须在{min}-{max}之间")
    private String name;

    /**
     * 资源路径URI
     */
    @Size(max = 128, message = "资源路径不能超过{max}")
    private String uri;

    /**
     * 图标
     */
    @Size(max = 32, message = "资源路径不能超过{max}")
    private String picture;

    /**
     * 权限标识
     */
    @Size(max = 500, message = "权限标识不能超过{max}")
    private String permission;

    /**
     * 是否超级管理员
     */
    private Boolean isSuper;

    /**
     * 排序号
     **/
    @DecimalMax(value = "60000", message = "排序号不能超过{value}")
    @DecimalMin(value = "0", message = "排序号不能小于{value}")
    private Integer sortNo = 1;

    /**
     * 描述
     */
    @Size(max = 128, message = "资源描述不能超过{max}")
    private String description;

}

