package cn.quantgroup.big.stms.sys.dto;

import cn.quantgroup.big.stms.sys.enums.ValueType;
import lombok.Data;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Data
public class DictDto {
    /**
     * 数据字典ID
     **/
    private Integer id;

    /**
     * 数据字典编码
     **/
    @NotNull(message = "数据字典编码不为空")
    @Size(min = 1, max = 32, message = "数据字典编码必须在{min}-{max}之间")
    private String code;

    /**
     * 数据字典其它编码
     **/
    @Size(min = 1, max = 32, message = "数据字典其它编码必须在{min}-{max}之间")
    private String other;

    /**
     * 数据字典名称
     */
    @NotNull(message = "数据字典名称不为空")
    @Size(min = 1, max = 64, message = "数据字典名称必须在{min}-{max}之间")
    private String name;

    /**
     * 排序号
     **/
    @DecimalMax(value = "60000", message = "排序号不能超过{value}")
    @DecimalMin(value = "0", message = "排序号不能小于{value}")
    private Integer sortNo = 1;

    /**
     * 描述
     */
    @Size(max = 128, message = "数据字典描述不能超过{max}")
    private String description;

    /**
     * 上级数据字典ID
     **/
    private Integer parentId;
    /**
     * 数据字典类型
     **/
    private ValueType type;
}
