package cn.quantgroup.big.stms.sys.dao;

import cn.quantgroup.big.stms.common.dao.BaseRepository;
import cn.quantgroup.big.stms.sys.model.User;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository
@Transactional
public interface UserDao extends BaseRepository<User, String> {
    User getByAccount(String account);
    User getByEmail(String email);
    User getByMobile(String mobile);


    @Modifying
    @Query("update User u set u.supplierCode = ?2 where u.id = ?1")
    int bindSupplierCode(String id,String supplierCode);

    Page<User> findAllByOrganizationId(String orgId, Pageable pageable);

    Page<User> findAllByOrganizationIdIn(List<String> orgIds, Pageable pageable);


    Page<User> findAllBySupplierCode(String supplierCode, Pageable pageable);
}
