package cn.quantgroup.big.stms.sys.model;

import cn.quantgroup.big.stms.common.model.BaseEntityVO;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;

/**
 * 配置信息，用来存放会发生变化的配置信息
 */
@Entity
@Table(name = "t_sys_ini")
@Getter
@Setter
public class Ini extends BaseEntityVO<Integer> {
    /**
     * 主键id
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    /**
     * 配置名称
     */
    @Column(name = "name")
    private String name;
    /**
     * 配置值
     */
    @Column(name = "value")
    private String value;
    /**
     *
     */
    @Column(name = "description")
    private String description;

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public void setId(Integer id) {
        this.id = id;
    }
}
