package cn.quantgroup.big.stms.sys.enums;

import cn.quantgroup.big.stms.common.enums.BaseEnum;
import cn.quantgroup.big.stms.common.exception.BizException;
import cn.quantgroup.big.stms.common.result.ResultCode;
import com.fasterxml.jackson.annotation.JsonCreator;

/**
 * @Author meng.xin@quantgroup.cn
 * @Date 2019-10-30 18:00
 * @Version 1.0
 */

public enum ResourceType implements BaseEnum<Integer> {
    GROUP("资源组", 1),
    MENU("菜单", 2),
    FUNCTION("功能", 3);

    private final String name;
    private final Integer value;

    ResourceType(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return value;
    }

    @Override
    public String getName() {
        return name;
    }

    @JsonCreator
    public static ResourceType get(int value) {
        for (ResourceType e : values()) {
            if (e.getValue().equals(value)) {
                return e;
            }
        }
        return null;
    }

    /**
     * 检查逻辑
     * @param parent
     * @return
     */
    public boolean logicalCheck(ResourceType parent) {
    	if (parent.equals(GROUP)) {
    		if (this.equals(FUNCTION)) {
    			throw new BizException("资源组无法添加功能类型资源", ResultCode.PARAM_ERROR);
			}
		} else if (parent.equals(MENU)) {
			if (!this.equals(FUNCTION)) {
				throw new BizException("菜单下只能添加功能类型资源", ResultCode.PARAM_ERROR);
			}
		} else if (parent.equals(FUNCTION)) {
			throw new BizException("功能下层无法添加其他类型资源", ResultCode.PARAM_ERROR);
		}
    	return true;
    }
}
