package cn.quantgroup.big.stms.sys.dto;

import cn.quantgroup.big.stms.common.enums.BasicDataStatus;
import cn.quantgroup.big.stms.sys.model.Role;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.LocalDateTime;
import java.time.ZoneId;

@Data
public class RoleV2Dto {

  private String id;
  private String code;
  private String name;
  private Integer tenantId;
  private String tenantName;
  private int userCount;
  private BasicDataStatus status;
  private String description;
  private String creator;
  @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
  private LocalDateTime createTime;

  public static RoleV2Dto from(Role role) {
    RoleV2Dto item = new RoleV2Dto();
    item.setId(role.getId());
    item.setName(role.getName());
    item.setCode(role.getCode());
    item.setTenantName(role.getTenantName());
    item.setTenantId(role.getTenantId());
    item.setStatus(role.getStatus());
    item.setDescription(role.getDescription());
    item.setCreator(role.getCreator());
    item.setCreateTime(
        LocalDateTime.ofInstant(role.getCreateTime().toInstant(), ZoneId.systemDefault()));
    return item;
  }

  public static RoleV2Dto from(Role role, int userCount) {
    RoleV2Dto item = from(role);
    item.setUserCount(userCount);
    return item;
  }
}
