package cn.quantgroup.big.stms.common.utils;

import cn.quantgroup.big.stms.common.exception.BizException;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/**
 * @author xinm
 * @date 2020/2/28
 */
@Slf4j
public class ZipUtils {

    /**
     * @param files   需要被压缩的文件
     * @param zipFile 压缩后的目标zip文件
     * @throws IOException
     */
    public static void zip(List<File> files, File zipFile) {
        List<Path> filesPath = Lists.newArrayList();
        for (File file : files) {
            if (null != file && file.exists() && file.isFile()) {
                filesPath.add(file.toPath());
            }
        }
        zip(filesPath, zipFile.toPath());
    }

    /**
     * @param files   需要被压缩的文件
     * @param zipFile 压缩后的目标zip文件
     * @throws IOException
     */
    private static void zip(List<Path> files, Path zipFile) {
        try (OutputStream outputStream = Files.newOutputStream(zipFile, StandardOpenOption.CREATE_NEW);
             ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream)) {
            for (Path file : files) {
                try (InputStream inputStream = Files.newInputStream(file);) {
                    zipOutputStream.putNextEntry(new ZipEntry(file.getFileName().toString()));
                    int len;
                    byte[] buffer = new byte[1024 * 10];
                    while ((len = inputStream.read(buffer)) > 0) {
                        zipOutputStream.write(buffer, 0, len);
                    }
                } catch (Exception e) {
                    throw e;
                }
            }
        } catch (Exception e) {
            log.error("文件{}打zip包发生异常:", zipFile.toString(), e);
            throw new BizException(e);
        }
    }
}
