package cn.quantgroup.big.stms.common.result;

/**
 * API调用结果状态码定义
 *
 * @author rong yang
 */
public enum ResultCode {
    SUCCESS(2000, "成功"),

    PARAM_ERROR(4000, "参数错误"),

    UNAUTHORIZED(4010, "未登录、请先登录"),

    REFRESH_TOKEN_EXPIRE(4011, "Refresh-Token过期，请重新登录系统"),
    FAIL_LOGIN_MAX(4012, "超过最大错误次数，请10分钟后重试"),

    FORBIDDEN(4030, "没有访问权限，禁止访问"),

    INVALID_USERNAME_OR_PASSWORD(4031, "用户名密码不正确"),

    INVALID_VERIFICATION_CODE(4032, "验证码不正确"),

    ACCESS_TOKEN_EXPIRE(4033, "Access-Token过期，请重新获取Access-Token"),

    INVALID_USERNAME_OR_PASSWORD_ORIGINAL(4034, "原密码不正确"),

    SERVICE_ERROR(5000, "服务器器异常"),

    DOWNLOAD_ERROR(6000, "有人正在下载,请稍后再试"),

    REPEAT_SUBMIT_ERROR(6010, "重复提交"),

    SUPPLIER_NON_EXISTENT(7000,"此供应商不存在，请先添加供应商"),

    ORGANIZATION_NO_EXISTENT(7001,"组织不存在"),


    UN_MERCHANT_ORGANIZATION(7002,"非供应商租户"),
    ROLE_NOT_EXISTENT(7004,"角色不存在"),
    ORGANIZATION_FROZEN(7003,"商户已解约，请联系平台申请重新入驻"),
    EXTERNAL_LOGIN_ERROR(4100,"第三方账号登录失败"),
    DISABLED_USER(4101,"用户已经禁用"),
    INVALID_PHONE(4102,"不可以验证的手机号码"),
    DUPLICATION_DATA(4103,"手机号码已经绑定，请解绑后再绑定"),
    BIND_PHONE_ERROR(4104,"手机绑定失败，请联系客服"),
    BIND_SUPPLIER_CODE_ERROR(4104,"供应链code绑定失败"),
    UN_DELETE_ORG(4105,"该组织结构不支持删除"),
    UN_FROZEN_ORG(4106,"当前组织不支持冻结"),
    UN_BIND_CODE(4107,"当前微信账户还未绑定成功"),
    INVALID_BIND_CODE(4108,"不可验证的绑定码"),
    AUTHORIZE_CODE_MISMATCH(4109,"授权码不匹配"),
    REFRESH_TOKEN_MISMATCH(4110, "Refresh-Token不匹配"),
    ;


    private Integer code;

    private String msg;


    private ResultCode(Integer code, String msg) {

        this.code = code;
        this.msg = msg;
    }


    public Integer getCode() {
        return code;
    }


    public String getMsg() {
        return msg;
    }

}
