package cn.quantgroup.big.stms.common.hibernate.usertype;

import cn.quantgroup.big.stms.common.context.EnumClassFactory;
import cn.quantgroup.big.stms.common.enums.BaseEnum;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Properties;

/**
 * 
 * <p>date: 2019年10月16日 下午5:25:38</p> 
 * <p>description:  自定义枚举类型处理</p>
 *   
 * 
 * @package com.matrix.core.hibernate.usertype
 * @author rong.yang/阳荣
 *
 * 使用方法：<br/>
 * 1. 枚举类要实现cn.quantgroup.big.common.enums.BaseEnum接口<br/>
 * 2. 在模型的枚举属性上增加以下注解<br/>
 * <p>
 * @Type(type="cn.quantgroup.big.stms.common.hibernate.usertype.UserEnumType",parameters={@Parameter(name="enumClass",value="枚举的全路径")})
 * </p>
 *
 */
public class UserEnumType<E extends Enum<?> & BaseEnum<?>> implements UserType, ParameterizedType {
    private static final String ENUM_CLASS = "enumClass";
    private static final String VALUE_FIELD = "value";
    private Class<E> enumClass;
    private int sqlType;
    
    
    @Override
    public void setParameterValues(Properties parameters) {
        if (null == parameters) {  
                throw new IllegalArgumentException("enum must set parameters");
        }
        
        try {
        	enumClass = (Class<E>) EnumClassFactory.getEnumClass(parameters.getProperty(ENUM_CLASS));
            //enumClass = (Class<E>) Class.forName(parameters.getProperty(ENUM_CLASS));
            Class<?> valueType = enumClass.getDeclaredField(VALUE_FIELD).getType();
            if(valueType.isAssignableFrom(Integer.class)){
                sqlType = Types.INTEGER;
            }else if(valueType.isAssignableFrom(String.class)){
                sqlType = Types.VARCHAR;
            }else{
                throw new IllegalArgumentException("enum value property type must be String or Integer");
            }
        } catch (NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException("enum set parameters set error!",e);
        }
    }

    @Override
    public int[] sqlTypes() {
        return new int[]{sqlType};
    }

    @SuppressWarnings("rawtypes")
    @Override
    public Class returnedClass() {
        return enumClass;
    }

    @Override
    public boolean equals(Object x, Object y) throws HibernateException {
        return (x!=null && y!=null) ? x.equals(y) : false;
    }

    @Override
    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor session, Object owner)
            throws HibernateException, SQLException {
        Object value = rs.getObject(names[0]);
        return of(value); 
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session)
            throws HibernateException, SQLException {
        Object val = null;
        if (null != value ) { 
            val = ((BaseEnum<?>)value).getValue();
        } 
        st.setObject(index, val);
    }

    @Override
    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable) value;
    }

    @Override
    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    @Override
    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
    
    private E of(Object value) {
        E[] enumConstants = enumClass.getEnumConstants();
        for (E e : enumConstants) {
            if (e.getValue().equals(value)) {
            	return e;
            }
        }
        return null;
    }
}
