package cn.quantgroup.big.stms.common.config;

import cn.quantgroup.tool.monitor.metric.api.TechOkHttpClient;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

import static java.util.concurrent.TimeUnit.MINUTES;
import static java.util.concurrent.TimeUnit.SECONDS;

/**
 * @version 2018/7/13 下午2:11
 * @auther jinsong.zhu
 */
@Configuration
public class OkHttpConfig {
    public final static int CONNECT_TIMEOUT = 20;//设置连接超时时间
    public final static int READ_TIMEOUT = 20;
    public final static int WRITE_TIMEOUT = 20;

/*    //注入brave-spring-boot-starter提供的techOkHttpClient
    @Resource
    private ITechOkHttpClient techOkHttpClient;*/

    private OkHttpClient.Builder defaultBuilder(int maxIdleConnections, long keepAliveDuration) {
        //创建okHttpClient
        OkHttpClient.Builder builder = TechOkHttpClient.createOkHttpClientBuilder()
                .retryOnConnectionFailure(true)
                .connectionPool(new ConnectionPool(maxIdleConnections, keepAliveDuration, MINUTES))
                .connectTimeout(CONNECT_TIMEOUT, SECONDS)
                .readTimeout(READ_TIMEOUT, SECONDS)
                .writeTimeout(WRITE_TIMEOUT, SECONDS);
        return builder;
    }

    private OkHttpClient.Builder defaultBuilder() {
        return defaultBuilder(10, 5);
    }

    @Bean
    @Scope
    public OkHttpClient defaultHttpClient() {
        return defaultBuilder().build();
    }

    private static final String HAO_AN_KEY = "b5140fb2-2c85-4b5a-abcf-3e97528014db";

    @Bean
    public OkHttpClient outerApiHttpClient() {
        OkHttpClient.Builder builder = defaultBuilder();

        //调用数据源 risk-data项目的接口需要加上一个header: key->b5140fb2-2c85-4b5a-abcf-3e97528014db
        Interceptor keyHeaderInterceptor = chain -> chain.proceed(chain.request().newBuilder()
                .header("key", HAO_AN_KEY)
                .build());
        builder.addInterceptor(keyHeaderInterceptor);

        HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
        // interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        builder.addInterceptor(interceptor);
        return builder.build();
    }
}
